import yaml
from support.config_tools import InitWithDict


class MultiAgentEmbedConfig(object):
    def __init__(self, init):
        self.Learn = MultiAgentEmbedConfig.Learn(init["Learn"])
        self.Arch = MultiAgentEmbedConfig.Arch(init["Arch"])

    class Learn(InitWithDict):
        feature_number = None
        save_mother_dir = None
        batch_size = None
        keep_prob = None
        learning_rate = None
        number_of_total_game = None
        max_seq_length = None
        feature_type = None
        iterate_num = None
        model_type = None
        apply_softmax = None
        predict_target = None
        player_Id_style = None
        sport = None
        apply_pid = None
        apply_stochastic = None

    class Arch(InitWithDict):
        def __init__(self, init):
            # super(TTLSTMCongfig.Arch, self).__init__(init)
            self.Episodic = MultiAgentEmbedConfig.Arch.Episodic(init["Episodic"])
            self.Dense = MultiAgentEmbedConfig.Arch.Dense(init["Dense"])
            self.Predict = MultiAgentEmbedConfig.Arch.Predict(init["Predict"])
            self.ScoreDiff = MultiAgentEmbedConfig.Arch.ScoreDiff(init["ScoreDiff"])

        class ScoreDiff(InitWithDict):
            layer_num = None
            n_hidden = None
            output_node = None
            lstm_layer_num = None
            h_size = None


        class Predict(InitWithDict):
            layer_num = None
            n_hidden = None
            output_node = None
            lstm_layer_num = None
            h_size = None
            predict_target = None

        class Episodic(InitWithDict):
            h_size = None
            latent_dim = None
            lstm_layer_num = None

        class Dense(InitWithDict):
            embed_layer_number = None
            policy_layer_number = None
            dense_layer_size = None
            output_layer_size = None


    @staticmethod
    def load(file_path):
        config = yaml.load(open(file_path, 'r'))
        return MultiAgentEmbedConfig(config)
